
/*:

@target MZ
@plugindesc ステージセレクト機能を追加します。
@author メロウ紙芝居
@url https://meroukamisibai.com/

@param variableStage
@text 選択ステージ変数
@desc　選んだステージのステージidを代入する変数。
@type variable
@default 0

@param variableOption
@text 選択オプション変数
@desc　選んだオプションのオプションidを代入する変数。
@type variable
@default 0

@param variableStageCursor
@text 選択ステージカーソル変数
@desc　ステージセレクトで選んだステージのカーソル位置を代入する変数。
@type variable
@default 0

@param variableOptionCursor
@text 選択オプションカーソル変数
@desc　ステージセレクトで選んだオプションのカーソル位置を代入する変数。
@type variable
@default 0

@help MK_StageSelect.js

何も選ばなかった場合はステージの変数とオプションの変数に0が入ります。
オプションの設定されてないステージを選んでもオプションの変数に0が入ります。


@command explanation_stageSelect
@text ---ステージセレクト---
@desc

@command stageSelect
@text ステージセレクト画面
@desc ステージセレクト画面を開きます。

@command title
@text タイトル名
@desc ステージセレクト画面のタイトルに名前を付けます。

@arg title
@text タイトル
@desc ステージセレクト画面のタイトル名です。
@type string

@command explanation_stage
@text ---ステージ---
@desc

@command stageAdd
@text ステージ追加
@desc 指定したステージを追加します。

@arg stage
@text ステージ
@desc 追加するステージのIDです。
@type number
@min 1
@default 1

@command stageRemove
@text ステージ外す
@desc 指定したステージを外します。

@arg stage
@text ステージ
@desc 外すステージのIDです。
@type number
@min 1
@default 1

@command stageAllRemove
@text 全ステージ外す
@desc 全てのステージを外します。

@command explanation_option
@text ---オプション---
@desc

@command optionAdd
@text オプション追加
@desc 指定したステージに指定したオプションを追加します。

@arg stage
@text ステージ
@desc オプションを追加するステージのIDです。
@type number
@min 1
@default 1

@arg option
@text オプション
@desc 追加するオプションのIDです。
@type number
@min 1
@default 1

@command optionRemove
@text オプション外す
@desc 指定したステージの指定したオプションを外します。

@arg stage
@text ステージ
@desc オプションを外すステージのIDです。
@type number
@min 1
@default 1

@arg option
@text オプション
@desc 外すオプションのIDです。
@type number
@min 1
@default 1

@command optionAllRemove
@text 全オプション外す
@desc 指定したステージの全てのオプションを外します。

@arg stage
@text ステージ
@desc 全オプションを外すステージのIDです。
@type number
@min 1
@default 1

@command allStageOptionAllRemove
@text 全ステージ全オプション外す
@desc 全てのステージの全てのオプションを外します。

@command explanation_other
@text ---その他---
@desc

@command score
@text スコア
@desc 指定したステージのスコアを設定します。

@arg stage
@text ステージ
@desc スコアを設定するステージのIDです。
@type number
@min 1
@default 1

@arg score
@text スコア
@desc 設定するスコアです。
@type string

@arg option
@text オプション
@desc スコアを設定するオプションのIDです。オプションがないステージのスコアは0で設定できます。
@type number
@min 0
@default 0

@command cursorStage
@text ステージカーソル開始位置
@desc ステージセレクト画面を開いた時のステージのカーソルの開始位置を設定します。

@arg cursor
@text カーソル位置
@desc カーソルの位置です。上から0で始まります。
@type number
@min 0
@default 0

@command cursorOption
@text オプションカーソル開始位置
@desc ステージセレクト画面を開いた時のオプションのカーソルの開始位置を設定します。

@arg cursor
@text カーソル位置
@desc カーソルの位置です。左から0で始まります。
@type number
@min 0
@default 0

*/

/////////////////模倣データベース/////////////////

var mk_stageSelect_data = {
    stages : [null],
    options : [null],
    parameters : {//パラメーターデータ
        variableStage : 0,
        variableOption : 0,
        variableStageCursor : 0,
        variableOptionCursor : 0,
    }
};

(() => {
    
    //----------模倣データベースオブジェクト----------
    
    let data = new MK_StageSelect_Data();

    //入力オブジェクト
    function MK_StageSelect_Data() {
        this.stage = null;
        this.option = null;
        this.id_stage = 0;
        this.id_stage_pictures = 0;
        this.id_option = 0;
    }

    //ステージ
    MK_StageSelect_Data.prototype.Stage = function(name) {//名前
        this.id_stage++;
        this.id_stage_pictures = 0;
        mk_stageSelect_data.stages[this.id_stage] = {
            id : this.id_stage,
            name : name,//名前
            icon : -1,//アイコン -1でなし
            scoreDisplay : false,//スコア表示させるか
            scoreWord : "",//スコア文字
            score : "",//スコア
            pictures : [null],//返す画像オブジェクト
            condition : "true"//選択条件 js(trueかfalseを返す)
        };
        this.stage = mk_stageSelect_data.stages[this.id_stage];
    };
    
    //アイコン設定
    MK_StageSelect_Data.prototype.Icon = function(icon) {//アイコンid
        this.stage.icon = icon;
    };
    
    //スコア設定
    MK_StageSelect_Data.prototype.Score = function(scoreWord, score) {//スコア文字, スコア
        this.stage.scoreDisplay = true;
        this.stage.scoreWord = scoreWord;//スコア文字
        this.stage.score = score;//初期スコア
    };
    
    //返す画像
    MK_StageSelect_Data.prototype.Pictures = function(name, optionId) {//画像名, オプションid
        this.id_stage_pictures++;
        this.stage.pictures[this.id_stage_pictures] =  {
            id : this.id_stage_pictures,
            picture : name,//返す画像名
            option : optionId || 0//オプションid（0は通常時）
        };
    };
    
    //選択条件
    MK_StageSelect_Data.prototype.Condition = function(condition) {//条件 js(trueかfalseを返す)
        this.stage.condition = condition;
    };
    
    //オプション
    MK_StageSelect_Data.prototype.Option = function(name) {//名前
        this.id_option++;
        mk_stageSelect_data.options[this.id_option] = {
            id : this.id_option,
            name : name,//名前
            scoreDisplay : true,//スコア表示させるか
            scoreReference : false//オプションが無い時のスコアを参照するか
        };
        this.option = mk_stageSelect_data.options[this.id_option];
    };
    
    //オプションのスコア表示するか
    MK_StageSelect_Data.prototype.OptionScoreDisplay = function(display) {//スコア表示するか
        this.option.scoreDisplay = display;
    };
    
    //オプションが無い時のスコアを参照するか
    MK_StageSelect_Data.prototype.OptionScoreReference = function(reference) {//スコア参照するか
        this.option.scoreReference = reference;
    };
    

    //----------模倣データベース入力場所----------
    
    //-----ここから
    
    const scoreWord = "BEST☆TIME";
    const initialTime = "--:--";
    
    data.Stage("チュートリアル");//---
    data.Pictures("stage_tutorial_game");
    data.Pictures("stage_tutorial_op", 3);
    data.Pictures("stage_tutorial_end", 4);
    //---
    
    data.Stage("ゴォウカン博物館");//---
    data.Score(scoreWord, initialTime);
    data.Condition("!$gameSwitches.value(52) || $gameSwitches.value(41)");
    data.Pictures("stage_1_game");
    data.Pictures("stage_1_op", 3);
    data.Pictures("stage_1_end", 4);
    data.Pictures("miss_1_1", 6);
    data.Pictures("miss_1_1", 7);
    data.Pictures("stage_miss_unopened", 8);
    //---
    
    data.Stage("カラクリ木馬");//---
    data.Score(scoreWord, initialTime);
    data.Condition("!$gameSwitches.value(52) || $gameSwitches.value(42)");
    data.Pictures("stage_2_game");
    data.Pictures("stage_2_op", 3);
    data.Pictures("stage_2_end", 4);
    data.Pictures("miss_2_1", 6);
    data.Pictures("miss_2_1", 7);
    data.Pictures("stage_miss_unopened", 8);
    //---
        
    data.Stage("無人モーモー牧場");//---
    data.Score(scoreWord, initialTime);
    data.Condition("!$gameSwitches.value(52) || $gameSwitches.value(43)");
    data.Pictures("stage_3_game");
    data.Pictures("stage_3_op", 3);
    data.Pictures("stage_3_end", 4);
    data.Pictures("miss_3_1", 6);
    data.Pictures("miss_3_1", 7);
    data.Pictures("stage_miss_unopened", 8);
    //---
    
    data.Stage("カニバレストラン");//---
    data.Score(scoreWord, initialTime);
    data.Condition("!$gameSwitches.value(52) || $gameSwitches.value(44)");
    data.Pictures("stage_4_game");
    data.Pictures("stage_4_op", 3);
    data.Pictures("stage_4_end", 4);
    data.Pictures("miss_4_1", 6);
    data.Pictures("miss_4_1", 7);
    data.Pictures("stage_miss_unopened", 8);
    //---
    
    data.Stage("タダノ城");//---
    data.Score(scoreWord, initialTime);
    data.Condition("!$gameSwitches.value(52) || $gameSwitches.value(45)");
    data.Pictures("stage_5_game");
    data.Pictures("stage_5_op", 3);
    data.Pictures("stage_5_end", 4);
    data.Pictures("miss_5_1", 6);
    data.Pictures("miss_5_1", 7);
    data.Pictures("stage_miss_unopened", 8);
    //---
    
    data.Stage("ゴォウカン博物館　～再～");//---
    data.Score(scoreWord, initialTime);
    data.Condition("!$gameSwitches.value(52) || $gameSwitches.value(46)");
    data.Pictures("stage_6_game");
    data.Pictures("stage_6_op", 3);
    data.Pictures("stage_6_end", 4);
    data.Pictures("miss_6_1", 6);
    data.Pictures("miss_6_1", 7);
    data.Pictures("stage_miss_unopened", 8);
    //---
    
    data.Stage("カラクリ木馬　～再～");//---
    data.Score(scoreWord, initialTime);
    data.Condition("!$gameSwitches.value(52) || $gameSwitches.value(47)");
    data.Pictures("stage_7_game");
    data.Pictures("stage_7_op", 3);
    data.Pictures("stage_7_end", 4);
    data.Pictures("miss_7_1", 6);
    data.Pictures("miss_7_1", 7);
    data.Pictures("stage_miss_unopened", 8);
    //---
        
    data.Stage("無人モーモー牧場　～再～");//---
    data.Score(scoreWord, initialTime);
    data.Condition("!$gameSwitches.value(52) || $gameSwitches.value(48)");
    data.Pictures("stage_8_game");
    data.Pictures("stage_8_op", 3);
    data.Pictures("stage_8_end", 4);
    data.Pictures("miss_8_9", 6);
    data.Pictures("miss_8_9", 7);
    data.Pictures("stage_miss_unopened", 8);
    //---
    
    data.Stage("カニバレストラン　～再～");//---
    data.Score(scoreWord, initialTime);
    data.Condition("!$gameSwitches.value(52) || $gameSwitches.value(49)");
    data.Pictures("stage_9_game");
    data.Pictures("stage_9_op", 3);
    data.Pictures("stage_9_end", 4);
    data.Pictures("miss_9_4", 6);
    data.Pictures("miss_9_4", 7);
    data.Pictures("stage_miss_unopened", 8);
    //---
    
    data.Stage("魔王城");//---
    data.Score(scoreWord, initialTime);
    data.Condition("!$gameSwitches.value(52) || $gameSwitches.value(50)");
    data.Pictures("stage_10_game");
    data.Pictures("stage_10_op", 3);
    data.Pictures("stage_10_end", 4);
    data.Pictures("miss_10_1", 6);
    data.Pictures("miss_10_1", 7);
    data.Pictures("stage_miss_unopened", 8);
    //---
    
    data.Stage("エンディング");//---
    data.Pictures("stage_end_scenario");
    data.Pictures("stage_end_stuffedRoll", 5);
    //---
    
    //---
    data.Option("フル");
    data.OptionScoreReference(true);
    
    data.Option("ゲーム");
    data.OptionScoreReference(true);
    
    data.Option("OPシナリオ");
    data.OptionScoreReference(true);
    
    data.Option("ENDシナリオ");
    data.OptionScoreReference(true);
    
    data.Option("スタッフロール");
    data.OptionScoreDisplay(false);
    
    data.Option("シナリオ");
    data.OptionScoreDisplay(false);
    
    data.Option("CG");
    data.OptionScoreDisplay(false);
    
    data.Option("未開放");
    data.OptionScoreDisplay(false);
    //---
        
    //-----ここまで

})();


/////////////////ステージデータオブジェクト/////////////

function MK_StageSelect_Stage(stage) {//模倣データベースのステージ
    this.id = stage.id;
    this.name = stage.name;//名前
    this.scores = [];//スコア 「オプションid:スコア」オプション無い時は0
    this.Score(0, stage.score);
    this.options = [];//選べるオプション オプションidが入る
}

//オプション追加
MK_StageSelect_Stage.prototype.OptionAdd = function(optionId) {//オプションid
    if(this.options.indexOf(optionId) == -1){
        this.options.push(optionId);
        if(!this.scores[optionId]){
            this.Score(optionId, mk_stageSelect_data.stages[this.id].score);
        }
    }
};

//オプション減らす
MK_StageSelect_Stage.prototype.OptionRemove = function(optionId) {//オプションid
    const index = this.options.indexOf(optionId);
    if(index != -1){
        this.options.splice(index, 1);
    }
};

//オプション全て外す
MK_StageSelect_Stage.prototype.OptionAllRemove = function() {
    this.options = [];
};

//スコア変更
MK_StageSelect_Stage.prototype.Score = function(optionId, score) {//オプションid（0はオプションが無い時）, スコア
    this.scores[optionId] = score;
};


/////////////////グローバルデータ/////////////////

var mk_stageSelect_game = null;

//ステージ選択データ
function MK_StageSelect_Game() {
    this.stages = [null];//MK_StageSelect_Stage ステージのデータ
    for(let r = 1; r < mk_stageSelect_data.stages.length; r++){
        this.stages[r] = new MK_StageSelect_Stage(mk_stageSelect_data.stages[r]);
    }
    this.title = "";//セレクト画面のタイトル
    this.selectStages = []//選べるステージ（id）
    this.cursorStage = -1;//ステージの開始カーソル位置。-1で無し
    this.cursorOption = -1;//オプションの開始カーソル位置。-1で無し
}

//----------基本----------

//ステージセレクト画面を開く
MK_StageSelect_Game.prototype.StageSelect = function() {
    SceneManager.push(MK_StageSelect_Scene);
};

//タイトルの名前
MK_StageSelect_Game.prototype.Title = function(title) {
    this.title = title;
};

//ステージ追加
MK_StageSelect_Game.prototype.StageAdd = function(stageId) {//ステージid
    if(this.selectStages.indexOf(stageId) == -1){
        this.selectStages.push(stageId);
    }
};

//ステージ外す
MK_StageSelect_Game.prototype.StageRemove = function(stageId) {//ステージid
    const index = this.selectStages.indexOf(stageId);
    if(index != -1){
        this.selectStages.splice(index, 1);
    }
};

//全ステージ外す
MK_StageSelect_Game.prototype.StageAllRemove = function() {
    this.selectStages = [];
};

//全ステージの全オプション外す
MK_StageSelect_Game.prototype.AllStageOptionAllRemove = function() {
    for (const stage of this.stages) {
        if (!!stage) {
            stage.OptionAllRemove();
        }
    }
};

//ステージのカーソル開始位置
MK_StageSelect_Game.prototype.CursorStage = function(index) {
    this.cursorStage = index;
};

//オプションのカーソル開始位置
MK_StageSelect_Game.prototype.CursorOption = function(index) {
    this.cursorOption = index;
};

//ステージ選択
MK_StageSelect_Game.prototype.Select = function(index1, index2) {//選択したステージのid, オプションのid
    if(mk_stageSelect_data.parameters.variableStage != 0){
        $gameVariables.setValue(mk_stageSelect_data.parameters.variableStage, index1);
    }
    if(mk_stageSelect_data.parameters.variableOption != 0){
        $gameVariables.setValue(mk_stageSelect_data.parameters.variableOption, index2);
    }
    if(mk_stageSelect_data.parameters.variableStageCursor != 0){
        $gameVariables.setValue(mk_stageSelect_data.parameters.variableStageCursor, this.cursorStage);
    }
    if(mk_stageSelect_data.parameters.variableOptionCursor != 0){
        $gameVariables.setValue(mk_stageSelect_data.parameters.variableOptionCursor, this.cursorOption);
    }
};


//----------更新----------

//セーブデータをロードした時にデータベースとステージが違う時に修正
MK_StageSelect_Game.prototype.GameUpdate = function() {
    //ステージ
    if(this.stages.length != mk_stageSelect_data.stages.length){
        if(this.stages.length < mk_stageSelect_data.stages.length){
            for(let r = this.stages.length; r < mk_stageSelect_data.stages.length; r++){
                this.stages[r] = new MK_StageSelect_Stage(mk_stageSelect_data.stages[r]);
            }
        }else{
            while(this.stages.length > mk_stageSelect_data.stages.length){
                this.stages.pop();
            }
        }
    }
};


/////////////////ステージセレクトシーン/////////////////
    
//シーン
function MK_StageSelect_Scene() {
    this.mk_stageGame = null;//選ばれているステージ
    this.mk_stageData = null;//選ばれているステージのデータ
    this.mk_option = null;//選ばれているオプションデータ
    this.mk_cursorStageIndex = 0;//ステージカーソル位置
    this.mk_cursorOptionIndex = 0;//オプションカーソル位置
    this.mk_windowUpdate = false;//スコア・ピクチャウィンドウ更新するか
    this.initialize(...arguments);
}

MK_StageSelect_Scene.prototype = Object.create(Scene_MenuBase.prototype);
MK_StageSelect_Scene.prototype.constructor = MK_StageSelect_Scene;

MK_StageSelect_Scene.prototype.initialize = function() {
    Scene_MenuBase.prototype.initialize.call(this);
    this.mk_cursorStageIndex = this.MK_CursorStageIndex();
    this.MK_UpdateStage(this.mk_cursorStageIndex);
    this.mk_cursorOptionIndex = this.MK_CursorOptionIndex();
    this.MK_UpdateOption(this.mk_cursorOptionIndex);
};

//初期ステージカーソル
MK_StageSelect_Scene.prototype.MK_CursorStageIndex = function() {
    if(mk_stageSelect_game.selectStages.length > 0 && mk_stageSelect_game.cursorStage != -1){
        if(mk_stageSelect_game.cursorStage < mk_stageSelect_game.selectStages.length){
            return mk_stageSelect_game.cursorStage;
        }else{
            return mk_stageSelect_game.selectStages.length - 1;
        }
    }else{
        return 0;
    }
};

//初期オプションカーソル
MK_StageSelect_Scene.prototype.MK_CursorOptionIndex = function() {
    if(!!this.mk_stageGame && mk_stageSelect_game.cursorOption != -1){
        if(mk_stageSelect_game.cursorOption < this.mk_stageGame.options.length){
            return mk_stageSelect_game.cursorOption;
        }else{
            return 0;
        }
    }else{
        return 0;
    }
};

//ステージ更新
MK_StageSelect_Scene.prototype.MK_UpdateStage = function(index) {//ステージid
    if(mk_stageSelect_game.selectStages.length > 0){
        this.mk_stageGame = mk_stageSelect_game.stages[mk_stageSelect_game.selectStages[index]];
        this.mk_stageData = mk_stageSelect_data.stages[mk_stageSelect_game.selectStages[index]];
    }else{
        this.mk_stageGame = null;
        this.mk_stageData = null;
    }
};

//オプション更新
MK_StageSelect_Scene.prototype.MK_UpdateOption = function(index) {//オプションid
    if(!!this.mk_stageGame && this.mk_stageGame.options.length > 0){
        this.mk_option = mk_stageSelect_data.options[this.mk_stageGame.options[index]];
    }else{
        this.mk_option = null;
    }
};

MK_StageSelect_Scene.prototype.create = function() {
    Scene_MenuBase.prototype.create.call(this);
    this.MK_CreateTitleWindow();
    this.MK_CreateSelectWindow();
    this.MK_CreateOptionWindow();
    this.MK_CreateScoreWindow();
    this.MK_CreatePictureWindow();
    this.MK_WindowRefresh();
};

MK_StageSelect_Scene.prototype.MK_CreateTitleWindow = function() {
    const rect = this.MK_CreateTitleWindowRect();
    this.mk_stageSelect_window_title = new MK_StageSelect_Window_Title(rect);
    this.addWindow(this.mk_stageSelect_window_title);
};

MK_StageSelect_Scene.prototype.MK_CreateTitleWindowRect = function() {
    const ww = Graphics.boxWidth / 3.5;
    const wh = this.calcWindowHeight(1, false);
    const wx = 50 + (Graphics.boxWidth / 3 - ww) / 2;
    const wy = 55;
    return new Rectangle(wx, wy, ww, wh);
};

MK_StageSelect_Scene.prototype.MK_CreateSelectWindow = function() {
    const rect = this.MK_CreateSelectWindowRect();
    this.mk_stageSelect_window = new MK_StageSelect_Window_Select(rect);
    this.mk_stageSelect_window.setHandler('ok', this.onOk.bind(this));
    this.mk_stageSelect_window.setHandler('cancel', this.onCancel.bind(this));
    if(mk_stageSelect_game.selectStages.length > 0){
        this.mk_stageSelect_window.forceSelect(this.mk_cursorStageIndex);
    }else{
        this.mk_stageSelect_window.deselect();
    }
    this.addWindow(this.mk_stageSelect_window);
};

MK_StageSelect_Scene.prototype.MK_CreateSelectWindowRect = function() {
    const ww = Graphics.boxWidth / 3;
    const wh = Graphics.boxHeight / 1.6;
    const wx = 50;
    const wy = 140;
    return new Rectangle(wx, wy, ww, wh);
};

MK_StageSelect_Scene.prototype.MK_CreateOptionWindow = function() {
    const rect = this.MK_CreateOptionWindowRect();
    this.mk_stageSelect_window_option = new MK_StageSelect_Window_Option(rect);
    this.mk_stageSelect_window_option.select(this.mk_cursorOptionIndex);
    this.mk_stageSelect_window_option.MK_UpdateOption(this.mk_stageGame);
    this.addWindow(this.mk_stageSelect_window_option);
};

MK_StageSelect_Scene.prototype.MK_CreateOptionWindowRect = function() {
    const ww = Graphics.boxWidth / 2.5;
    const wh = this.calcWindowHeight(1, true);
    const wx = 10 + Graphics.boxWidth / 2;
    const wy = 55;
    return new Rectangle(wx, wy, ww, wh);
};

MK_StageSelect_Scene.prototype.MK_CreateScoreWindow = function() {
    const rect = this.MK_CreateScoreWindowRect();
    this.mk_stageSelect_window_score = new MK_StageSelect_Window_Score(rect);
    this.addWindow(this.mk_stageSelect_window_score);
};

MK_StageSelect_Scene.prototype.MK_CreateScoreWindowRect = function() {
    const ww = Graphics.boxWidth / 2.5;
    const wh = this.calcWindowHeight(1, false);
    const wx = 50 + (Graphics.boxWidth / 3 - ww) / 2;
    const wy = Graphics.boxHeight - this.calcWindowHeight(1, false) - 15;
    return new Rectangle(wx, wy, ww, wh);
};

MK_StageSelect_Scene.prototype.MK_CreatePictureWindow = function() {
    const rect = this.MK_CreatePictureWindowRect();
    this.mk_stageSelect_window_picture = new MK_StageSelect_Window_Picture(rect);
    this.addWindow(this.mk_stageSelect_window_picture);
};

MK_StageSelect_Scene.prototype.MK_CreatePictureWindowRect = function() {
    const ww = Graphics.boxWidth / 2;
    const wh = Graphics.boxHeight / 1.6;
    const wx = 10 + Graphics.boxWidth / 2 + (Graphics.boxWidth / 2.5 - ww) / 2;
    const wy = 140;
    return new Rectangle(wx, wy, ww, wh);
};

MK_StageSelect_Scene.prototype.onOk = function() {
    mk_stageSelect_game.CursorStage(this.mk_stageSelect_window._index);
    if(this.mk_stageGame.options.length > 0){
        mk_stageSelect_game.CursorOption(this.mk_stageSelect_window_option._index);
    }else{
        mk_stageSelect_game.CursorOption(-1);
    }
    mk_stageSelect_game.Select(this.mk_stageGame.id, (!!this.mk_option) ? this.mk_option.id : 0);
    this.popScene();
};

MK_StageSelect_Scene.prototype.onCancel = function() {
    mk_stageSelect_game.Select(0, 0);
    this.popScene();
};

MK_StageSelect_Scene.prototype.update = function() {
    Scene_Base.prototype.update.call(this);
    if(this.mk_cursorStageIndex != this.mk_stageSelect_window._index){
        this.mk_cursorStageIndex = this.mk_stageSelect_window._index;
        this.MK_UpdateStage(this.mk_cursorStageIndex);
        this.MK_UpdateOption(this.mk_cursorOptionIndex);
        this.mk_stageSelect_window_option.MK_UpdateOption(this.mk_stageGame);
        this.mk_windowUpdate = true;
    }
    if(this.mk_cursorOptionIndex != this.mk_stageSelect_window_option._index){
        this.mk_cursorOptionIndex = this.mk_stageSelect_window_option._index;
        this.MK_UpdateOption(this.mk_cursorOptionIndex);
        this.mk_windowUpdate = true;
    }
    if(this.mk_windowUpdate){
        this.MK_WindowRefresh();
        this.mk_windowUpdate = false;
    }
};

MK_StageSelect_Scene.prototype.MK_WindowRefresh = function() {
    this.mk_stageSelect_window_score.MK_StageUpdate(this.mk_stageGame, this.mk_cursorOptionIndex);
    this.mk_stageSelect_window_picture.MK_StageUpdate(this.mk_stageGame, this.mk_cursorOptionIndex);
};


/////////////////ステージセレクトタイトルウィンドウ/////////////////

function MK_StageSelect_Window_Title() {
    this.initialize(...arguments);
}

MK_StageSelect_Window_Title.prototype = Object.create(Window_Base.prototype);
MK_StageSelect_Window_Title.prototype.constructor = MK_StageSelect_Window_Title;

MK_StageSelect_Window_Title.prototype.initialize = function(rect) {
    Window_Base.prototype.initialize.call(this, rect);
    this.refresh();
};

MK_StageSelect_Window_Title.prototype.refresh = function() {
    const name = mk_stageSelect_game.title;
    this.drawText(name, 0, 0, this.contentsWidth(), 'center');
};


/////////////////ステージセレクトウィンドウ/////////////////

function MK_StageSelect_Window_Select() {
    this.initialize(...arguments);
}

MK_StageSelect_Window_Select.prototype = Object.create(Window_Selectable.prototype);
MK_StageSelect_Window_Select.prototype.constructor = MK_StageSelect_Window_Select;

MK_StageSelect_Window_Select.prototype.initialize = function(rect) {
    Window_Selectable.prototype.initialize.call(this, rect);
    this.select(0);
    this.activate();
    this.refresh();
};

MK_StageSelect_Window_Select.prototype.maxCols = function() {
    return 1;
};

MK_StageSelect_Window_Select.prototype.maxItems = function() {
    return mk_stageSelect_game.selectStages.length;
};

MK_StageSelect_Window_Select.prototype.drawItem = function(index) {
    const rect = this.itemLineRect(index);
    this.changePaintOpacity(this.MK_Enable(index));
    const textWidth = this.drawTextEx(this.MK_Icon(index) , rect.x, rect.y);
    this.drawText(this.MK_Name(index), rect.x  + textWidth, rect.y, rect.width - textWidth);
    this.changePaintOpacity(true);
};

//選択できるか
MK_StageSelect_Window_Select.prototype.MK_Enable = function(index) {
    if(mk_stageSelect_game.selectStages.length > 0){
        const stage = mk_stageSelect_data.stages[mk_stageSelect_game.selectStages[index]];
        return (eval(stage.condition)) ? true : false;
    }
    return false;
};

//ステージアイコン返す
MK_StageSelect_Window_Select.prototype.MK_Icon = function(index) {
    const id = mk_stageSelect_data.stages[mk_stageSelect_game.selectStages[index]].icon;
    if(id != -1){
        return "\\I[" + id + "]";
    }
    return "";
};

//ステージ名返す
MK_StageSelect_Window_Select.prototype.MK_Name = function(index) {
    return mk_stageSelect_data.stages[mk_stageSelect_game.selectStages[index]].name;
};

//決定キー押したとき
MK_StageSelect_Window_Select.prototype.isCurrentItemEnabled = function() {
    return this.MK_Enable(this._index);
};

//選べない時の効果音
MK_StageSelect_Window_Select.prototype.playBuzzerSound = function() {
    if(mk_stageSelect_game.selectStages.length > 0){
        Window_Base.prototype.playBuzzerSound.call(this);
    }
};


/////////////////ステージセレクトオプションウィンドウ/////////////////

function MK_StageSelect_Window_Option() {
    this.mk_options = null;//選ばれているステージのオプションデータ
    this.mk_cursorIndex = 0;//カーソル位置
    
    this.initialize(...arguments);
}

MK_StageSelect_Window_Option.prototype = Object.create(Window_Selectable.prototype);
MK_StageSelect_Window_Option.prototype.constructor = MK_StageSelect_Window_Option;

MK_StageSelect_Window_Option.prototype.initialize = function(rect) {
    Window_Selectable.prototype.initialize.call(this, rect);
};

MK_StageSelect_Window_Option.prototype.maxCols = function() {
    if(this.MK_ExistenceOption()){
        return this.mk_options.length;
   }else{
        return 1;
   }
};

MK_StageSelect_Window_Option.prototype.maxItems = function() {
    if(this.MK_ExistenceOption()){
        return this.mk_options.length;
   }else{
        return 0;
   }
};

MK_StageSelect_Window_Option.prototype.update = function() {
    Window_Selectable.prototype.update.call(this);
    if(this.MK_ExistenceOption() && this._index != this.mk_cursorIndex){
        this.refresh();
        this.mk_cursorIndex = this._index;
    }
};

MK_StageSelect_Window_Option.prototype.processTouch = function() {
    if (this.isOpenAndActive()) {
        if (TouchInput.isTriggered()) {
            this.onTouchSelect(true);
        }
        if (TouchInput.isClicked()) {
            this.onTouchOk();
        } else if (TouchInput.isCancelled()) {
            this.onTouchCancel();
        }
    }
};

MK_StageSelect_Window_Option.prototype.drawItem = function(index) {
    if(this._index == index){
        const rect1 = this.itemRect(index);
        const color = ColorManager.pendingColor();
        this.changePaintOpacity(false);
        this.contents.fillRect(rect1.x, rect1.y, rect1.width, rect1.height, color);
        this.changePaintOpacity(true);
    }
    const rect2 = this.itemLineRect(index);
    this.drawText(mk_stageSelect_data.options[this.mk_options[index]].name, rect2.x, rect2.y, rect2.width, 'center');
};

MK_StageSelect_Window_Option.prototype.refreshCursor = function() {
    if(this.index() >= 0){
    }else{
        Window_Selectable.prototype.refreshCursor.call(this);
    }
};

//ステージ変えた時のオプション更新
MK_StageSelect_Window_Option.prototype.MK_UpdateOption = function(stage) {//選択中のステージ
    this.mk_options = (!!stage) ? stage.options : null;
    if(this.MK_ExistenceOption()){
        this.activate();
        this.show();
        this.select((this._index < this.mk_options.length) ? this._index : 0);
        this.refresh();
        this.mk_cursorIndex = this._index;
    }else{
        this.deactivate();
        this.hide();
    }
};

//オプションがあるか
MK_StageSelect_Window_Option.prototype.MK_ExistenceOption = function() {
    return (!!this.mk_options　&& this.mk_options.length > 0) ? true : false;
};


/////////////////ステージセレクトスコアウィンドウ/////////////////

function MK_StageSelect_Window_Score() {
    this.mk_stage = null;//選ばれているステージ
    this.mk_optionId = 0;//選ばれているオプションid
    
    this.initialize(...arguments);
}

MK_StageSelect_Window_Score.prototype = Object.create(Window_Base.prototype);
MK_StageSelect_Window_Score.prototype.constructor = MK_StageSelect_Window_Score;

MK_StageSelect_Window_Score.prototype.initialize = function(rect) {
    Window_Base.prototype.initialize.call(this, rect);
};

MK_StageSelect_Window_Score.prototype.refresh = function() {
    const data = this.mk_stage && mk_stageSelect_data.stages[this.mk_stage.id];
    if(this.MK_ScoreDisplayCheck()){
        this.contents.clear();
        this.show();
        const scoreWord = mk_stageSelect_data.stages[this.mk_stage.id].scoreWord;
        this.drawText(scoreWord, 0, 0, this.contentsWidth());
        this.drawText(this.MK_Score(), 0, 0, this.contentsWidth(), 'right');
    }else{
        this.hide();
    }
};

//スコア表示するか判定
MK_StageSelect_Window_Score.prototype.MK_ScoreDisplayCheck = function() {
    if(!!this.mk_stage && mk_stageSelect_data.stages[this.mk_stage.id].scoreDisplay){
        if(this.mk_stage.options.length > 0 ){
            const option = mk_stageSelect_data.options[this.mk_stage.options[this.mk_optionId]];
            if(option.scoreDisplay){
                return true;
            }else{
                return false;
            }
        }
        return true;
    }
    return false;
};

//スコア返す
MK_StageSelect_Window_Score.prototype.MK_Score = function() {
    if(this.mk_stage.options.length > 0){
        const option = mk_stageSelect_data.options[this.mk_stage.options[this.mk_optionId]];
        if(!option.scoreReference){
            return this.mk_stage.scores[this.mk_stage.options[this.mk_optionId]];
        }
    }
    return this.mk_stage.scores[0];
};

//ステージとオプションid更新
MK_StageSelect_Window_Score.prototype.MK_StageUpdate = function(stage, optionId) {//ステージ, オプションid
    this.mk_stage = stage;
    this.mk_optionId = optionId;
    this.refresh();
};


/////////////////ステージセレクトピクチャウィンドウ/////////////////

function MK_StageSelect_Window_Picture() {
    this.mk_stage = null;//選ばれているステージ
    this.mk_optionId = 0;//選ばれているオプションid
    
    this.initialize(...arguments);
}

MK_StageSelect_Window_Picture.prototype = Object.create(Window_Base.prototype);
MK_StageSelect_Window_Picture.prototype.constructor = MK_StageSelect_Window_Picture;

MK_StageSelect_Window_Picture.prototype.initialize = function(rect) {
    Window_Base.prototype.initialize.call(this, rect);
};

MK_StageSelect_Window_Picture.prototype.refresh = function() {
    this.contents.clear();
    if(!!this.mk_stage && mk_stageSelect_data.stages[this.mk_stage.id].pictures.length > 0){
        const picture = this.MK_Picture();
        if(picture != ""){
            const bitmap = ImageManager.loadPicture(picture);
            bitmap.addLoadListener(function() {
                let scaleWidth = bitmap.width;
                let scaleHeight = bitmap.height;
                if(bitmap.width > this.contentsWidth() || bitmap.height > this.contentsHeight()){
                    let w = 100;
                    let h = 100;
                    while(true){
                        if(bitmap.width * w / 100 <= this.contentsWidth() && bitmap.height * h / 100 <= this.contentsHeight()){
                            scaleWidth = bitmap.width * w / 100;
                            scaleHeight = bitmap.height * h / 100;
                            break;
                        }
                        w--;
                        h--;
                    }
                }
                dx = this.contentsWidth() / 2 - scaleWidth / 2;
                dy = this.contentsHeight() / 2 - scaleHeight / 2;
                this.contents.blt(bitmap, 0, 0, bitmap.width, bitmap.height, dx, dy, scaleWidth, scaleHeight);
            }.bind(this));
        };
    }
};

//画像返す
MK_StageSelect_Window_Picture.prototype.MK_Picture = function() {
    const pictures = mk_stageSelect_data.stages[this.mk_stage.id].pictures;
    for(let r = pictures.length - 1; r > 0; r--){
        if(pictures[r].option == this.mk_stage.options[this.mk_optionId]){
            return pictures[r].picture;
        }
    }
    for(let r = pictures.length - 1; r > 0; r--){
        if(pictures[r].option == 0){
            return pictures[r].picture;
        }
    }
    return "";
};

//ステージとオプションid更新
MK_StageSelect_Window_Picture.prototype.MK_StageUpdate = function(stage, optionId) {//ステージ, オプションid
    this.mk_stage = stage;
    this.mk_optionId = optionId;
    this.refresh();
};


(() => {
    
    /////////////////プラグイン関係/////////////////
    
    const pluginName = "MK_StageSelect";
    
    //----------プラグインパラメーター----------
    
    const parameters = PluginManager.parameters(pluginName);
    mk_stageSelect_data.parameters.variableStage = Number(parameters["variableStage"]) || 0;
    mk_stageSelect_data.parameters.variableOption = Number(parameters["variableOption"]) || 0;
    mk_stageSelect_data.parameters.variableStageCursor = Number(parameters["variableStageCursor"]) || 0;
    mk_stageSelect_data.parameters.variableOptionCursor = Number(parameters["variableOptionCursor"]) || 0;
    
    
    //----------プラグインコマンド----------

    //ステージセレクト画面開く
    PluginManager.registerCommand(pluginName, "stageSelect", args => {
        mk_stageSelect_game.StageSelect();
    });
    
    //ステージセレクトタイトル
    PluginManager.registerCommand(pluginName, "title", args => {
        mk_stageSelect_game.Title(args.title);
    });
    
    //ステージ追加
    PluginManager.registerCommand(pluginName, "stageAdd", args => {
        mk_stageSelect_game.StageAdd(Number(args.stage));
    });
    
    //ステージ外す
    PluginManager.registerCommand(pluginName, "stageRemove", args => {
        mk_stageSelect_game.StageRemove(Number(args.stage));
    });
    
    //全ステージ外す
    PluginManager.registerCommand(pluginName, "stageAllRemove", args => {
        mk_stageSelect_game.StageAllRemove();
    });
    
    //ステージのオプション追加
    PluginManager.registerCommand(pluginName, "optionAdd", args => {
        mk_stageSelect_game.stages[Number(args.stage)].OptionAdd(Number(args.option));
    });
    
    //ステージのオプション外す
    PluginManager.registerCommand(pluginName, "optionRemove", args => {
        mk_stageSelect_game.stages[Number(args.stage)].OptionRemove(Number(args.option));
    });
    
    //ステージの全オプション外す
    PluginManager.registerCommand(pluginName, "optionAllRemove", args => {
        mk_stageSelect_game.stages[Number(args.stage)].OptionAllRemove();
    });
    
    //全ステージ全オプション外す
    PluginManager.registerCommand(pluginName, "allStageOptionAllRemove", args => {
        mk_stageSelect_game.AllStageOptionAllRemove();
    });
    
    //スコア変更
    PluginManager.registerCommand(pluginName, "score", args => {
        mk_stageSelect_game.stages[Number(args.stage)].Score(Number(args.option), args.score);
    });
    
    //ステージのカーソル開始位置
    PluginManager.registerCommand(pluginName, "cursorStage", args => {
        mk_stageSelect_game.CursorStage(Number(args.cursor));
    });
    
    //オプションのカーソル開始位置
    PluginManager.registerCommand(pluginName, "cursorOption", args => {
        mk_stageSelect_game.CursorOption(Number(args.cursor));
    });
    
    
    /////////////////元々オブジェクト/////////////////
    
    //ゲーム開始時作成データ
    const _DataManager_createGameObjects = DataManager.createGameObjects;
    DataManager.createGameObjects = function() {
        _DataManager_createGameObjects.apply(this, arguments);
        mk_stageSelect_game = new MK_StageSelect_Game();
    };
    
    //セーブ
    const _DataManager_makeSaveContents = DataManager.makeSaveContents;
    DataManager.makeSaveContents = function() {
        let contents = _DataManager_makeSaveContents.apply(this, arguments);
        contents.mk_stageSelect = mk_stageSelect_game;
        return contents;
    };
    
    //ロード
    const _DataManager_extractSaveContents = DataManager.extractSaveContents;
    DataManager.extractSaveContents = function(contents) {
        _DataManager_extractSaveContents.apply(this, arguments);
        mk_stageSelect_game = contents.mk_stageSelect;
        mk_stageSelect_game.GameUpdate();
    };
    
})();
